// Deform by iq (2009)

// Use defines here rather than edit the body of the code.

//## This file comprises the full form of the set of definitions used  by  TheEmu
//## to adapt fragment shaders from ShaderTot.com to work with the VGHD software.
//## In most cases just copying this file to the start of the shader is all  that
//## is necessary. However, it does not cover all possible cases, notably it does
//## not cover the use of texture cubes.
//##
//## In this file I have included extra explanatory comments using   //##.  These
//## should probably be omitted when using this file yourself as  they  serve  no
//## purpose in the final shader source and clutter it up.

/////////////////////////////////////////////////////////////////////////////////

//## Please, always acknowledge the origin of the shader, Add more detail should
//## that be appropriate.

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

//## The following definitions equivalencing ShaderToy's  iGlobalTime  to  VGHD's
//## u_Elapsed and iResolution to u_WindowSize and are essentialy always  needed.
//## This could be done by editing the body of the shaders replacing each use  of
//## of iGlobalTime with u_Elapsed and each use of iResolution with u_WindowSize,
//## but it is better no to edit the shaders if it can be avoided.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//## Many of ShaderToy's shaders reference iMouse to get the mouse  position  and
//## detect button presses. Often this is not unimportant and static mouse is all
//## that has to be simulated, in which case all that is needed is a simple
//##
//##     #define iMouse vec4(0.0,0.0, 0.0,0.0)
//##
//## but in other cases a dynamic mouse simulation is required,  as  is done here.
//## This simple Automatic Mouse simulates scanning the mouse over the full  range
//## of the screen with the X and Y scanning frequencies being different. The form
//## of the scanning may be altered to suit a particular shader  by  changing  the
//## expression used for MOUSE_POS.  If MOUSE_POS is changed then it should always
//## provide a position bewteen (0.0,0.0) and (u_WindowSize.x,u_WindowSize.y).  It
//## has not yet been necessary to simulate mouse button presses,  but this can be
//## done by changing MOUSE_PRESS should it ever be required. 

#define iMouse AUTO_MOUSE

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

//## The ShaderToy shaders often use textures inputs named iChannel0 etc.  which
//## can be configured, outside of the shader source,  to reference an image,  a
//## video or a sound source (or, I think, a keyboard). With VGHD it is possible
//## to use these to access Sprite, ClipSprite or ClipNameSprite data  depending
//## on how the .scn is configured.
//## 
//## Note, the names used here are chosen to match ShaderToy, but in general any
//## names can be used.
//##
//## Note, with VGHD I have not yet been able to discover a way to  access  more 
//## than one texture at a time and so all of the iChannel's declared here  will
//## reference the same texture. This has proved to be of little importance, but
//## may affect the details of the images produced. 

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;

//## With VGHD the range of the P argument's components of the texture functions
//## is 0.0 to 1.0 whereas with ShaderToy it appears that the upper  limits  are
//## given by the number of pixels in each direction, typically 512 or 64. Hence
//## we use the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }

vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias)
 { return texture2D(sampler,fract(P),Bias);
 }

#define texture2D texture2D_Fract

// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//
void main( void )
{
    // normalized coordinates (-1 to 1 vertically)
    vec2 p = (-iResolution.xy + 2.0*gl_FragCoord.xy)/iResolution.y;
//
    // angle of each pixel to the center of the screen
    float a = atan(p.y,p.x);
 //   
    // modified distance metric. Usually distance = (x + y)^(1/2). By replacing all the "2" numbers
    // by 32 in that formula we can create distance metrics other than the euclidean. The higher the
    // exponent, then more square the metric becomes. More information here:
 //   
    // http://en.wikipedia.org/wiki/Minkowski_distance
//    
    float r = pow( pow(p.x*p.x,16.0) + pow(p.y*p.y,16.0), 1.0/32.0 );
//    
    // index texture by angle and radious, and animate along radius 
// old was 	 vec2 uv = vec2( 0.5/r + 0.5*iGlobalTime, a/3.1416 ); ~ET made slower
    vec2 uv = vec2( 0.5/r + 0.15*iGlobalTime,
                    a/3.1416 );
//
    // fetch color and darken in the center
    vec3 col =  texture2D( iChannel0, uv ).xyz * r;
//
    gl_FragColor = vec4( col, 1.0 );
}
//